@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetAlarmContactGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlarmContactGroups.
 * @property ids A list of Alarm Contact Group IDs.
 * @property nameRegex A regex string to filter results by Alarm Contact Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 */
public data class GetAlarmContactGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetAlarmContactGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetAlarmContactGroupsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetAlarmContactGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlarmContactGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetAlarmContactGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value A list of Alarm Contact Group IDs.
     */
    @JvmName("mwgwtleqlfyuppmv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Alarm Contact Group IDs.
     */
    @JvmName("hnwxvvkmvbjvixaj")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by Alarm Contact Group name.
     */
    @JvmName("agoxntixsywqijsd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("nmjugvgtvflbomqp")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAlarmContactGroupsPlainArgs = GetAlarmContactGroupsPlainArgs(
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
