@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetAlarmContactsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getAlarmContacts.
 * @property chanelType The alarm notification method. Alarm notifications can be sent by using `Email` or `DingWebHook`.
 * @property chanelValue The alarm notification target.
 * @property ids A list of alarm contact IDs.
 * @property nameRegex A regex string to filter results by alarm contact name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * > **NOTE:** Specify at least one of the following alarm notification targets: phone number, email address, webhook URL of the DingTalk chatbot, and TradeManager ID.
 */
public data class GetAlarmContactsPlainArgs(
    public val chanelType: String? = null,
    public val chanelValue: String? = null,
    public val ids: List<String>? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetAlarmContactsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetAlarmContactsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetAlarmContactsPlainArgs.builder()
            .chanelType(chanelType?.let({ args0 -> args0 }))
            .chanelValue(chanelValue?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetAlarmContactsPlainArgs].
 */
@PulumiTagMarker
public class GetAlarmContactsPlainArgsBuilder internal constructor() {
    private var chanelType: String? = null

    private var chanelValue: String? = null

    private var ids: List<String>? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    /**
     * @param value The alarm notification method. Alarm notifications can be sent by using `Email` or `DingWebHook`.
     */
    @JvmName("ogwnojelecxgsboy")
    public suspend fun chanelType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.chanelType = mapped
    }

    /**
     * @param value The alarm notification target.
     */
    @JvmName("wfwlkrynfvgwllub")
    public suspend fun chanelValue(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.chanelValue = mapped
    }

    /**
     * @param value A list of alarm contact IDs.
     */
    @JvmName("yfljdhfkxkghsxmy")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of alarm contact IDs.
     */
    @JvmName("cmtpnfbwlabmcscq")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value A regex string to filter results by alarm contact name.
     */
    @JvmName("rtjplrvwxpgfvbrt")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     * > **NOTE:** Specify at least one of the following alarm notification targets: phone number, email address, webhook URL of the DingTalk chatbot, and TradeManager ID.
     */
    @JvmName("dsfbgrxejltnuxni")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetAlarmContactsPlainArgs = GetAlarmContactsPlainArgs(
        chanelType = chanelType,
        chanelValue = chanelValue,
        ids = ids,
        nameRegex = nameRegex,
        outputFile = outputFile,
    )
}
