@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetDynamicTagGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getDynamicTagGroups.
 * @property ids A list of Dynamic Tag Group IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of the resource. Valid values: `RUNNING`, `FINISH`.
 * @property tagKey The tag key of the tag.
 */
public data class GetDynamicTagGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
    public val tagKey: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetDynamicTagGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetDynamicTagGroupsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetDynamicTagGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 }))
            .tagKey(tagKey?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetDynamicTagGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetDynamicTagGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var status: String? = null

    private var tagKey: String? = null

    /**
     * @param value A list of Dynamic Tag Group IDs.
     */
    @JvmName("mfitumufwkydujyj")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Dynamic Tag Group IDs.
     */
    @JvmName("jqmldriwbncnphdr")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gmnfgxjtfceakvbf")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of the resource. Valid values: `RUNNING`, `FINISH`.
     */
    @JvmName("tuuygyymxfoufkdc")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    /**
     * @param value The tag key of the tag.
     */
    @JvmName("bsjhammwmyxaukss")
    public suspend fun tagKey(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tagKey = mapped
    }

    internal fun build(): GetDynamicTagGroupsPlainArgs = GetDynamicTagGroupsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        status = status,
        tagKey = tagKey,
    )
}
