@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetGroupMetricRulesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getGroupMetricRules.
 * @property dimensions The dimensions that specify the resources to be associated with the alert rule.
 * @property enableState EnableState.
 * @property groupId The ID of the application group.
 * @property groupMetricRuleName The name of the alert rule.
 * @property ids A list of Group Metric Rule IDs.
 * @property metricName The name of the metric.
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property namespace The namespace of the service.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property status The status of Group Metric Rule.
 */
public data class GetGroupMetricRulesPlainArgs(
    public val dimensions: String? = null,
    public val enableState: Boolean? = null,
    public val groupId: String? = null,
    public val groupMetricRuleName: String? = null,
    public val ids: List<String>? = null,
    public val metricName: String? = null,
    public val nameRegex: String? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val status: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetGroupMetricRulesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetGroupMetricRulesPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetGroupMetricRulesPlainArgs.builder()
            .dimensions(dimensions?.let({ args0 -> args0 }))
            .enableState(enableState?.let({ args0 -> args0 }))
            .groupId(groupId?.let({ args0 -> args0 }))
            .groupMetricRuleName(groupMetricRuleName?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .metricName(metricName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .status(status?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetGroupMetricRulesPlainArgs].
 */
@PulumiTagMarker
public class GetGroupMetricRulesPlainArgsBuilder internal constructor() {
    private var dimensions: String? = null

    private var enableState: Boolean? = null

    private var groupId: String? = null

    private var groupMetricRuleName: String? = null

    private var ids: List<String>? = null

    private var metricName: String? = null

    private var nameRegex: String? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    private var status: String? = null

    /**
     * @param value The dimensions that specify the resources to be associated with the alert rule.
     */
    @JvmName("gdsyuatneyekxmvs")
    public suspend fun dimensions(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dimensions = mapped
    }

    /**
     * @param value EnableState.
     */
    @JvmName("nvvkxlhsivrohisy")
    public suspend fun enableState(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableState = mapped
    }

    /**
     * @param value The ID of the application group.
     */
    @JvmName("yyspmojmcioyhvmi")
    public suspend fun groupId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupId = mapped
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("fmjbelqagsdbgxwq")
    public suspend fun groupMetricRuleName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.groupMetricRuleName = mapped
    }

    /**
     * @param value A list of Group Metric Rule IDs.
     */
    @JvmName("yvynfrhrdcafjros")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Group Metric Rule IDs.
     */
    @JvmName("pelekifglmfxdbwl")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the metric.
     */
    @JvmName("jckbojobprutnuri")
    public suspend fun metricName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metricName = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("gslbahgekqthnmht")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The namespace of the service.
     */
    @JvmName("vxppvphbfjgcmukv")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("gulxxputmihmross")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The status of Group Metric Rule.
     */
    @JvmName("uiddqmjcehknlakn")
    public suspend fun status(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.status = mapped
    }

    internal fun build(): GetGroupMetricRulesPlainArgs = GetGroupMetricRulesPlainArgs(
        dimensions = dimensions,
        enableState = enableState,
        groupId = groupId,
        groupMetricRuleName = groupMetricRuleName,
        ids = ids,
        metricName = metricName,
        nameRegex = nameRegex,
        namespace = namespace,
        outputFile = outputFile,
        status = status,
    )
}
