@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetHybridMonitorDatasPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHybridMonitorDatas.
 * @property end The timestamp that specifies the end of the time range to query.
 * @property namespace The name of the namespace.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property period The interval at which monitoring data is collected. Unit: seconds.
 * @property promSql The name of the metric. Note PromQL statements are supported.
 * @property start The timestamp that specifies the beginning of the time range to query.
 */
public data class GetHybridMonitorDatasPlainArgs(
    public val end: String,
    public val namespace: String,
    public val outputFile: String? = null,
    public val period: String? = null,
    public val promSql: String,
    public val start: String,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetHybridMonitorDatasPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetHybridMonitorDatasPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetHybridMonitorDatasPlainArgs.builder()
            .end(end.let({ args0 -> args0 }))
            .namespace(namespace.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .period(period?.let({ args0 -> args0 }))
            .promSql(promSql.let({ args0 -> args0 }))
            .start(start.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridMonitorDatasPlainArgs].
 */
@PulumiTagMarker
public class GetHybridMonitorDatasPlainArgsBuilder internal constructor() {
    private var end: String? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    private var period: String? = null

    private var promSql: String? = null

    private var start: String? = null

    /**
     * @param value The timestamp that specifies the end of the time range to query.
     */
    @JvmName("aimpaalmqhrltcco")
    public suspend fun end(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.end = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("wwwbkcdxhyqushft")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("xkdkaruwkslmkkje")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The interval at which monitoring data is collected. Unit: seconds.
     */
    @JvmName("ntcbqsrcccqjcsil")
    public suspend fun period(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.period = mapped
    }

    /**
     * @param value The name of the metric. Note PromQL statements are supported.
     */
    @JvmName("jsglshfulvkhlllf")
    public suspend fun promSql(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.promSql = mapped
    }

    /**
     * @param value The timestamp that specifies the beginning of the time range to query.
     */
    @JvmName("yiaagrbuyttxaggw")
    public suspend fun start(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.start = mapped
    }

    internal fun build(): GetHybridMonitorDatasPlainArgs = GetHybridMonitorDatasPlainArgs(
        end = end ?: throw PulumiNullFieldException("end"),
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        outputFile = outputFile,
        period = period,
        promSql = promSql ?: throw PulumiNullFieldException("promSql"),
        start = start ?: throw PulumiNullFieldException("start"),
    )
}
