@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetHybridMonitorSlsTasksPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getHybridMonitorSlsTasks.
 * @property ids A list of Hybrid Monitor Sls Task IDs.
 * @property keyword The keyword that is used to search for metric import tasks.
 * @property namespace The name of the namespace.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetHybridMonitorSlsTasksPlainArgs(
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetHybridMonitorSlsTasksPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetHybridMonitorSlsTasksPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetHybridMonitorSlsTasksPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetHybridMonitorSlsTasksPlainArgs].
 */
@PulumiTagMarker
public class GetHybridMonitorSlsTasksPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyword: String? = null

    private var namespace: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value A list of Hybrid Monitor Sls Task IDs.
     */
    @JvmName("ulhbjcajkjaksqce")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Hybrid Monitor Sls Task IDs.
     */
    @JvmName("lidvdwodxgypmimm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The keyword that is used to search for metric import tasks.
     */
    @JvmName("uqxglpcaodcrbiey")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value The name of the namespace.
     */
    @JvmName("oivlptjrdtgaxmrx")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("huqkccwhdocgmegh")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("bkmltvlbyhnmmujl")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ifgdryobvjhahswo")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetHybridMonitorSlsTasksPlainArgs = GetHybridMonitorSlsTasksPlainArgs(
        ids = ids,
        keyword = keyword,
        namespace = namespace,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
