@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetMetricRuleBlackListsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMetricRuleBlackLists.
 * @property category Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
 * @property ids A list of Metric Rule Black List IDs.
 * @property metricRuleBlackListId The first ID of the resource
 * @property nameRegex A regex string to filter results by Group Metric Rule name.
 * @property namespace The data namespace of the cloud service.
 * @property order
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetMetricRuleBlackListsPlainArgs(
    public val category: String? = null,
    public val ids: List<String>? = null,
    public val metricRuleBlackListId: String? = null,
    public val nameRegex: String? = null,
    public val namespace: String? = null,
    public val order: Int? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetMetricRuleBlackListsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetMetricRuleBlackListsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetMetricRuleBlackListsPlainArgs.builder()
            .category(category?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .metricRuleBlackListId(metricRuleBlackListId?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .namespace(namespace?.let({ args0 -> args0 }))
            .order(order?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricRuleBlackListsPlainArgs].
 */
@PulumiTagMarker
public class GetMetricRuleBlackListsPlainArgsBuilder internal constructor() {
    private var category: String? = null

    private var ids: List<String>? = null

    private var metricRuleBlackListId: String? = null

    private var nameRegex: String? = null

    private var namespace: String? = null

    private var order: Int? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value Cloud service classification. For example, Redis includes kvstore_standard, kvstore_sharding, and kvstore_splitrw.
     */
    @JvmName("clasifbqbieikeos")
    public suspend fun category(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.category = mapped
    }

    /**
     * @param value A list of Metric Rule Black List IDs.
     */
    @JvmName("qqfgvdrsstijhngn")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Metric Rule Black List IDs.
     */
    @JvmName("oxdurqchllsaeagd")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The first ID of the resource
     */
    @JvmName("ppmdqqqsqgufungd")
    public suspend fun metricRuleBlackListId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metricRuleBlackListId = mapped
    }

    /**
     * @param value A regex string to filter results by Group Metric Rule name.
     */
    @JvmName("owwrkouoqbxbrdil")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The data namespace of the cloud service.
     */
    @JvmName("ubfsungiojhmtgbq")
    public suspend fun namespace(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.namespace = mapped
    }

    /**
     * @param value
     */
    @JvmName("yxngftwbiwddtyna")
    public suspend fun order(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.order = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("fqdyasiaacydofkt")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("rocujygcqkqcbjky")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("awniaqsvuryhfsar")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetMetricRuleBlackListsPlainArgs = GetMetricRuleBlackListsPlainArgs(
        category = category,
        ids = ids,
        metricRuleBlackListId = metricRuleBlackListId,
        nameRegex = nameRegex,
        namespace = namespace,
        order = order,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
