@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetMetricRuleTemplatesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMetricRuleTemplates.
 * @property enableDetails Valid values: `true` or `false`. Default to `false`. Set it to `true` can output more details about resource attributes.
 * @property ids A list of Metric Rule Template IDs.
 * @property keyword The name of the alert template. You can perform fuzzy search based on the template name.
 * @property metricRuleTemplateName The name of the alert template.
 * @property nameRegex A regex string to filter results by Metric Rule Template name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property templateId The ID of the alert template.
 */
public data class GetMetricRuleTemplatesPlainArgs(
    public val enableDetails: Boolean? = null,
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val metricRuleTemplateName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val templateId: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetMetricRuleTemplatesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetMetricRuleTemplatesPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetMetricRuleTemplatesPlainArgs.builder()
            .enableDetails(enableDetails?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .metricRuleTemplateName(metricRuleTemplateName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .templateId(templateId?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMetricRuleTemplatesPlainArgs].
 */
@PulumiTagMarker
public class GetMetricRuleTemplatesPlainArgsBuilder internal constructor() {
    private var enableDetails: Boolean? = null

    private var ids: List<String>? = null

    private var keyword: String? = null

    private var metricRuleTemplateName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var templateId: String? = null

    /**
     * @param value Valid values: `true` or `false`. Default to `false`. Set it to `true` can output more details about resource attributes.
     */
    @JvmName("qepdekulcqomtukn")
    public suspend fun enableDetails(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.enableDetails = mapped
    }

    /**
     * @param value A list of Metric Rule Template IDs.
     */
    @JvmName("vcsrbleyxjtletjv")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Metric Rule Template IDs.
     */
    @JvmName("xxkhyxpcgbrgrtfx")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The name of the alert template. You can perform fuzzy search based on the template name.
     */
    @JvmName("vyekrdybsaegeqyj")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value The name of the alert template.
     */
    @JvmName("wqrhdinowxirvclv")
    public suspend fun metricRuleTemplateName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.metricRuleTemplateName = mapped
    }

    /**
     * @param value A regex string to filter results by Metric Rule Template name.
     */
    @JvmName("ekrmimpcqrhnkkvi")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("hdsndaiegcyprvpv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The ID of the alert template.
     */
    @JvmName("oyvkcwqdyoyljebn")
    public suspend fun templateId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.templateId = mapped
    }

    internal fun build(): GetMetricRuleTemplatesPlainArgs = GetMetricRuleTemplatesPlainArgs(
        enableDetails = enableDetails,
        ids = ids,
        keyword = keyword,
        metricRuleTemplateName = metricRuleTemplateName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        templateId = templateId,
    )
}
