@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetMonitorGroupInstancesPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMonitorGroupInstances.
 * @property ids
 * @property keyword
 * @property outputFile
 */
public data class GetMonitorGroupInstancesPlainArgs(
    public val ids: String,
    public val keyword: String? = null,
    public val outputFile: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetMonitorGroupInstancesPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetMonitorGroupInstancesPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetMonitorGroupInstancesPlainArgs.builder()
            .ids(ids.let({ args0 -> args0 }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMonitorGroupInstancesPlainArgs].
 */
@PulumiTagMarker
public class GetMonitorGroupInstancesPlainArgsBuilder internal constructor() {
    private var ids: String? = null

    private var keyword: String? = null

    private var outputFile: String? = null

    /**
     * @param value
     */
    @JvmName("sugnpvmvxtjppddu")
    public suspend fun ids(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value
     */
    @JvmName("usmseqwsvvsefxep")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value
     */
    @JvmName("lwnuauymgsjddjhm")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    internal fun build(): GetMonitorGroupInstancesPlainArgs = GetMonitorGroupInstancesPlainArgs(
        ids = ids ?: throw PulumiNullFieldException("ids"),
        keyword = keyword,
        outputFile = outputFile,
    )
}
