@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetMonitorGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getMonitorGroups.
 * @property dynamicTagRuleId The ID of the tag rule.
 * @property ids A list of Monitor Group IDs.
 * @property includeTemplateHistory The include template history.
 * @property keyword The keyword to be matched.
 * @property monitorGroupName The name of the application group.
 * @property nameRegex A regex string to filter results by Monitor Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property selectContactGroups The select contact groups.
 * @property tags
 * @property type The type of the application group. Valid values: `custom`, `ehpc_cluster`, `kubernetes`.
 */
public data class GetMonitorGroupsPlainArgs(
    public val dynamicTagRuleId: String? = null,
    public val ids: List<String>? = null,
    public val includeTemplateHistory: Boolean? = null,
    public val keyword: String? = null,
    public val monitorGroupName: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val selectContactGroups: Boolean? = null,
    public val tags: Map<String, String>? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetMonitorGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetMonitorGroupsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetMonitorGroupsPlainArgs.builder()
            .dynamicTagRuleId(dynamicTagRuleId?.let({ args0 -> args0 }))
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .includeTemplateHistory(includeTemplateHistory?.let({ args0 -> args0 }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .monitorGroupName(monitorGroupName?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .selectContactGroups(selectContactGroups?.let({ args0 -> args0 }))
            .tags(tags?.let({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetMonitorGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetMonitorGroupsPlainArgsBuilder internal constructor() {
    private var dynamicTagRuleId: String? = null

    private var ids: List<String>? = null

    private var includeTemplateHistory: Boolean? = null

    private var keyword: String? = null

    private var monitorGroupName: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var selectContactGroups: Boolean? = null

    private var tags: Map<String, String>? = null

    private var type: String? = null

    /**
     * @param value The ID of the tag rule.
     */
    @JvmName("rapinedwyplusoju")
    public suspend fun dynamicTagRuleId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.dynamicTagRuleId = mapped
    }

    /**
     * @param value A list of Monitor Group IDs.
     */
    @JvmName("hhlpifgosnwsqvbq")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Monitor Group IDs.
     */
    @JvmName("sgrqpjylfudymnec")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The include template history.
     */
    @JvmName("rxhdipkiehkosvvl")
    public suspend fun includeTemplateHistory(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.includeTemplateHistory = mapped
    }

    /**
     * @param value The keyword to be matched.
     */
    @JvmName("btogudvdxboicvyf")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value The name of the application group.
     */
    @JvmName("cmyhmdhntxeqrfoi")
    public suspend fun monitorGroupName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.monitorGroupName = mapped
    }

    /**
     * @param value A regex string to filter results by Monitor Group name.
     */
    @JvmName("qpoxxcsjypnbwscs")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("aiiivrgcaotabgms")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value The select contact groups.
     */
    @JvmName("ifveuwgleuwcvysu")
    public suspend fun selectContactGroups(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.selectContactGroups = mapped
    }

    /**
     * @param value
     */
    @JvmName("cufdnfkvcddftvxv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param values
     */
    @JvmName("qswppilglkmlrjpf")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.tags = mapped
    }

    /**
     * @param value The type of the application group. Valid values: `custom`, `ehpc_cluster`, `kubernetes`.
     */
    @JvmName("hexvcbfxrjicwmwb")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetMonitorGroupsPlainArgs = GetMonitorGroupsPlainArgs(
        dynamicTagRuleId = dynamicTagRuleId,
        ids = ids,
        includeTemplateHistory = includeTemplateHistory,
        keyword = keyword,
        monitorGroupName = monitorGroupName,
        nameRegex = nameRegex,
        outputFile = outputFile,
        selectContactGroups = selectContactGroups,
        tags = tags,
        type = type,
    )
}
