@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetSiteMonitorsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSiteMonitors.
 * @property ids A list of Site Monitor IDs.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property taskId Task ID.
 * @property taskType Task Type.
 */
public data class GetSiteMonitorsPlainArgs(
    public val ids: List<String>? = null,
    public val outputFile: String? = null,
    public val taskId: String? = null,
    public val taskType: String? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetSiteMonitorsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetSiteMonitorsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetSiteMonitorsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .taskId(taskId?.let({ args0 -> args0 }))
            .taskType(taskType?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSiteMonitorsPlainArgs].
 */
@PulumiTagMarker
public class GetSiteMonitorsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var outputFile: String? = null

    private var taskId: String? = null

    private var taskType: String? = null

    /**
     * @param value A list of Site Monitor IDs.
     */
    @JvmName("vselfpwnxektcxyf")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Site Monitor IDs.
     */
    @JvmName("magrgovshosubysb")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("ekairvbbdnmrfggw")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value Task ID.
     */
    @JvmName("rsotcyrfmrmulgix")
    public suspend fun taskId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.taskId = mapped
    }

    /**
     * @param value Task Type.
     */
    @JvmName("yuegfawxlhdulduo")
    public suspend fun taskType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.taskType = mapped
    }

    internal fun build(): GetSiteMonitorsPlainArgs = GetSiteMonitorsPlainArgs(
        ids = ids,
        outputFile = outputFile,
        taskId = taskId,
        taskType = taskType,
    )
}
