@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GetSlsGroupsPlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getSlsGroups.
 * @property ids A list of Sls Group IDs. Its element value is same as Sls Group Name.
 * @property keyword The keywords of the `sls_group_name` or `sls_group_description` of the Sls Group.
 * @property nameRegex A regex string to filter results by Sls Group name.
 * @property outputFile File name where to save data source results (after running `pulumi preview`).
 * @property pageNumber
 * @property pageSize
 */
public data class GetSlsGroupsPlainArgs(
    public val ids: List<String>? = null,
    public val keyword: String? = null,
    public val nameRegex: String? = null,
    public val outputFile: String? = null,
    public val pageNumber: Int? = null,
    public val pageSize: Int? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GetSlsGroupsPlainArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GetSlsGroupsPlainArgs =
        com.pulumi.alicloud.cms.inputs.GetSlsGroupsPlainArgs.builder()
            .ids(ids?.let({ args0 -> args0.map({ args0 -> args0 }) }))
            .keyword(keyword?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .outputFile(outputFile?.let({ args0 -> args0 }))
            .pageNumber(pageNumber?.let({ args0 -> args0 }))
            .pageSize(pageSize?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetSlsGroupsPlainArgs].
 */
@PulumiTagMarker
public class GetSlsGroupsPlainArgsBuilder internal constructor() {
    private var ids: List<String>? = null

    private var keyword: String? = null

    private var nameRegex: String? = null

    private var outputFile: String? = null

    private var pageNumber: Int? = null

    private var pageSize: Int? = null

    /**
     * @param value A list of Sls Group IDs. Its element value is same as Sls Group Name.
     */
    @JvmName("lorkjtjicydkeppc")
    public suspend fun ids(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param values A list of Sls Group IDs. Its element value is same as Sls Group Name.
     */
    @JvmName("jmjtgskuwjhixbnm")
    public suspend fun ids(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> args0 })
        this.ids = mapped
    }

    /**
     * @param value The keywords of the `sls_group_name` or `sls_group_description` of the Sls Group.
     */
    @JvmName("iudiuburqbhmnaeq")
    public suspend fun keyword(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.keyword = mapped
    }

    /**
     * @param value A regex string to filter results by Sls Group name.
     */
    @JvmName("wciaccfsdmppdrub")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value File name where to save data source results (after running `pulumi preview`).
     */
    @JvmName("qwbihvgiyjjapgjv")
    public suspend fun outputFile(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.outputFile = mapped
    }

    /**
     * @param value
     */
    @JvmName("tgolhrglpisbcmiv")
    public suspend fun pageNumber(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageNumber = mapped
    }

    /**
     * @param value
     */
    @JvmName("ukoeqrwkgxlwbriy")
    public suspend fun pageSize(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.pageSize = mapped
    }

    internal fun build(): GetSlsGroupsPlainArgs = GetSlsGroupsPlainArgs(
        ids = ids,
        keyword = keyword,
        nameRegex = nameRegex,
        outputFile = outputFile,
        pageNumber = pageNumber,
        pageSize = pageSize,
    )
}
