@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property critical The critical level. See `critical` below.
 * @property info The info level. See `info` below.
 * @property warn The warn level. See `warn` below.
 */
public data class GroupMetricRuleEscalationsArgs(
    public val critical: Output<GroupMetricRuleEscalationsCriticalArgs>? = null,
    public val info: Output<GroupMetricRuleEscalationsInfoArgs>? = null,
    public val warn: Output<GroupMetricRuleEscalationsWarnArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs =
        com.pulumi.alicloud.cms.inputs.GroupMetricRuleEscalationsArgs.builder()
            .critical(critical?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .info(info?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .warn(warn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [GroupMetricRuleEscalationsArgs].
 */
@PulumiTagMarker
public class GroupMetricRuleEscalationsArgsBuilder internal constructor() {
    private var critical: Output<GroupMetricRuleEscalationsCriticalArgs>? = null

    private var info: Output<GroupMetricRuleEscalationsInfoArgs>? = null

    private var warn: Output<GroupMetricRuleEscalationsWarnArgs>? = null

    /**
     * @param value The critical level. See `critical` below.
     */
    @JvmName("kxhvttdtjnfsriqa")
    public suspend fun critical(`value`: Output<GroupMetricRuleEscalationsCriticalArgs>) {
        this.critical = value
    }

    /**
     * @param value The info level. See `info` below.
     */
    @JvmName("fwdeqpirbeucrukj")
    public suspend fun info(`value`: Output<GroupMetricRuleEscalationsInfoArgs>) {
        this.info = value
    }

    /**
     * @param value The warn level. See `warn` below.
     */
    @JvmName("pitqttdcufuqeunv")
    public suspend fun warn(`value`: Output<GroupMetricRuleEscalationsWarnArgs>) {
        this.warn = value
    }

    /**
     * @param value The critical level. See `critical` below.
     */
    @JvmName("imsejsvvuibmjevf")
    public suspend fun critical(`value`: GroupMetricRuleEscalationsCriticalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.critical = mapped
    }

    /**
     * @param argument The critical level. See `critical` below.
     */
    @JvmName("eoqofqaaojocctkf")
    public suspend fun critical(argument: suspend GroupMetricRuleEscalationsCriticalArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMetricRuleEscalationsCriticalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.critical = mapped
    }

    /**
     * @param value The info level. See `info` below.
     */
    @JvmName("qwsuvplfkkyerxbd")
    public suspend fun info(`value`: GroupMetricRuleEscalationsInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.info = mapped
    }

    /**
     * @param argument The info level. See `info` below.
     */
    @JvmName("ptrwxqgqbajadwyw")
    public suspend fun info(argument: suspend GroupMetricRuleEscalationsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMetricRuleEscalationsInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.info = mapped
    }

    /**
     * @param value The warn level. See `warn` below.
     */
    @JvmName("drgdygboplujqxwh")
    public suspend fun warn(`value`: GroupMetricRuleEscalationsWarnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warn = mapped
    }

    /**
     * @param argument The warn level. See `warn` below.
     */
    @JvmName("ynobxmwmrqhqetfr")
    public suspend fun warn(argument: suspend GroupMetricRuleEscalationsWarnArgsBuilder.() -> Unit) {
        val toBeMapped = GroupMetricRuleEscalationsWarnArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.warn = mapped
    }

    internal fun build(): GroupMetricRuleEscalationsArgs = GroupMetricRuleEscalationsArgs(
        critical = critical,
        info = info,
        warn = warn,
    )
}
