@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.GroupMetricRuleTargetArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property arn The Alibaba Cloud Resource Name (ARN) of the resource.
 * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
 * @property id The ID of the resource for which alerts are triggered.
 * @property jsonParams The parameters of the alert callback. The parameters are in the JSON format.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 */
public data class GroupMetricRuleTargetArgs(
    public val arn: Output<String>? = null,
    public val id: Output<String>? = null,
    public val jsonParams: Output<String>? = null,
    public val level: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.GroupMetricRuleTargetArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.GroupMetricRuleTargetArgs =
        com.pulumi.alicloud.cms.inputs.GroupMetricRuleTargetArgs.builder()
            .arn(arn?.applyValue({ args0 -> args0 }))
            .id(id?.applyValue({ args0 -> args0 }))
            .jsonParams(jsonParams?.applyValue({ args0 -> args0 }))
            .level(level?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [GroupMetricRuleTargetArgs].
 */
@PulumiTagMarker
public class GroupMetricRuleTargetArgsBuilder internal constructor() {
    private var arn: Output<String>? = null

    private var id: Output<String>? = null

    private var jsonParams: Output<String>? = null

    private var level: Output<String>? = null

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the resource.
     * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
     */
    @JvmName("sugoccrelubvjujv")
    public suspend fun arn(`value`: Output<String>) {
        this.arn = value
    }

    /**
     * @param value The ID of the resource for which alerts are triggered.
     */
    @JvmName("cwrclhwrihubmxwg")
    public suspend fun id(`value`: Output<String>) {
        this.id = value
    }

    /**
     * @param value The parameters of the alert callback. The parameters are in the JSON format.
     */
    @JvmName("rihvbgfasbyggffm")
    public suspend fun jsonParams(`value`: Output<String>) {
        this.jsonParams = value
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("bsvjmehgirhbqral")
    public suspend fun level(`value`: Output<String>) {
        this.level = value
    }

    /**
     * @param value The Alibaba Cloud Resource Name (ARN) of the resource.
     * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
     */
    @JvmName("btmgdftsmbictume")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.arn = mapped
    }

    /**
     * @param value The ID of the resource for which alerts are triggered.
     */
    @JvmName("ljmtjcgcruequbkb")
    public suspend fun id(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.id = mapped
    }

    /**
     * @param value The parameters of the alert callback. The parameters are in the JSON format.
     */
    @JvmName("bxymjosgsuohrfcl")
    public suspend fun jsonParams(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.jsonParams = mapped
    }

    /**
     * @param value The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
     */
    @JvmName("acislrqldqpkicht")
    public suspend fun level(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.level = mapped
    }

    internal fun build(): GroupMetricRuleTargetArgs = GroupMetricRuleTargetArgs(
        arn = arn,
        id = id,
        jsonParams = jsonParams,
        level = level,
    )
}
