@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskAttachLabelArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property name The tag key of the metric.
 * @property value The tag value of the metric.
 */
public data class HybridMonitorSlsTaskAttachLabelArgs(
    public val name: Output<String>? = null,
    public val `value`: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskAttachLabelArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskAttachLabelArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskAttachLabelArgs.builder()
            .name(name?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskAttachLabelArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskAttachLabelArgsBuilder internal constructor() {
    private var name: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The tag key of the metric.
     */
    @JvmName("rhxisskmcbbwlnyx")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value The tag value of the metric.
     */
    @JvmName("isggvpqlnqunfwpc")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The tag key of the metric.
     */
    @JvmName("excixlkcktgnxylq")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value The tag value of the metric.
     */
    @JvmName("fwdkmjsbrielrpbt")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HybridMonitorSlsTaskAttachLabelArgs = HybridMonitorSlsTaskAttachLabelArgs(
        name = name,
        `value` = `value`,
    )
}
