@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property expresses The extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property filter The conditions that are used to filter logs imported from Log Service. See `filter` below.
 * @property groupBies The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
 * @property statistics The method that is used to aggregate logs imported from Log Service. See `statistics` below.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigArgs(
    public val expresses: Output<List<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>>? = null,
    public val filter: Output<HybridMonitorSlsTaskSlsProcessConfigFilterArgs>? = null,
    public val groupBies: Output<List<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>>? = null,
    public val statistics: Output<List<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigArgs.builder()
            .expresses(
                expresses?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .filter(filter?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .groupBies(
                groupBies?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .statistics(
                statistics?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigArgsBuilder internal constructor() {
    private var expresses: Output<List<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>>? = null

    private var filter: Output<HybridMonitorSlsTaskSlsProcessConfigFilterArgs>? = null

    private var groupBies: Output<List<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>>? = null

    private var statistics: Output<List<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>>? = null

    /**
     * @param value The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("ktvblmuownjquccn")
    public suspend fun expresses(`value`: Output<List<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>>) {
        this.expresses = value
    }

    @JvmName("bwmobixgnukcmxoh")
    public suspend fun expresses(vararg values: Output<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>) {
        this.expresses = Output.all(values.asList())
    }

    /**
     * @param values The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("oqiuywbbdgtiyork")
    public suspend fun expresses(values: List<Output<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>>) {
        this.expresses = Output.all(values)
    }

    /**
     * @param value The conditions that are used to filter logs imported from Log Service. See `filter` below.
     */
    @JvmName("nijxraapfjlfqvvp")
    public suspend fun filter(`value`: Output<HybridMonitorSlsTaskSlsProcessConfigFilterArgs>) {
        this.filter = value
    }

    /**
     * @param value The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("wnhcevlvnxjmedkq")
    public suspend fun groupBies(`value`: Output<List<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>>) {
        this.groupBies = value
    }

    @JvmName("yktbthqqtlbphaxp")
    public suspend fun groupBies(vararg values: Output<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>) {
        this.groupBies = Output.all(values.asList())
    }

    /**
     * @param values The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("obcgpdginchfujdn")
    public suspend fun groupBies(values: List<Output<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>>) {
        this.groupBies = Output.all(values)
    }

    /**
     * @param value The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("jiycsakbycotjoaj")
    public suspend fun statistics(`value`: Output<List<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>>) {
        this.statistics = value
    }

    @JvmName("govrkcgtevsypfln")
    public suspend fun statistics(vararg values: Output<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>) {
        this.statistics = Output.all(values.asList())
    }

    /**
     * @param values The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("vlousxvpxykmrwxs")
    public suspend fun statistics(values: List<Output<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>>) {
        this.statistics = Output.all(values)
    }

    /**
     * @param value The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("ptmnenefaekykrdc")
    public suspend fun expresses(`value`: List<HybridMonitorSlsTaskSlsProcessConfigExpressArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.expresses = mapped
    }

    /**
     * @param argument The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("quqgbucdcdrcdceu")
    public suspend fun expresses(argument: List<suspend HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expresses = mapped
    }

    /**
     * @param argument The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("rlnjydtlkoyplrtn")
    public suspend fun expresses(vararg argument: suspend HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.expresses = mapped
    }

    /**
     * @param argument The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("dhyglrculmwydxqc")
    public suspend fun expresses(argument: suspend HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.expresses = mapped
    }

    /**
     * @param values The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("hqitsscscjoldxhq")
    public suspend fun expresses(vararg values: HybridMonitorSlsTaskSlsProcessConfigExpressArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.expresses = mapped
    }

    /**
     * @param value The conditions that are used to filter logs imported from Log Service. See `filter` below.
     */
    @JvmName("ljlchswpanhnmaei")
    public suspend fun filter(`value`: HybridMonitorSlsTaskSlsProcessConfigFilterArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filter = mapped
    }

    /**
     * @param argument The conditions that are used to filter logs imported from Log Service. See `filter` below.
     */
    @JvmName("fbkkkomucughjiyb")
    public suspend fun filter(argument: suspend HybridMonitorSlsTaskSlsProcessConfigFilterArgsBuilder.() -> Unit) {
        val toBeMapped = HybridMonitorSlsTaskSlsProcessConfigFilterArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.filter = mapped
    }

    /**
     * @param value The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("mfwrtjkpbouerooc")
    public suspend fun groupBies(`value`: List<HybridMonitorSlsTaskSlsProcessConfigGroupByArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.groupBies = mapped
    }

    /**
     * @param argument The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("kgeliyueuucdbisk")
    public suspend fun groupBies(argument: List<suspend HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.groupBies = mapped
    }

    /**
     * @param argument The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("soudvjnorknrwsss")
    public suspend fun groupBies(vararg argument: suspend HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.groupBies = mapped
    }

    /**
     * @param argument The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("oqpwtlduttxcnfve")
    public suspend fun groupBies(argument: suspend HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.groupBies = mapped
    }

    /**
     * @param values The dimension based on which data is aggregated. This parameter is equivalent to the GROUP BY clause in SQL. See `group_by` below.
     */
    @JvmName("pwprgackjdfujwfp")
    public suspend fun groupBies(vararg values: HybridMonitorSlsTaskSlsProcessConfigGroupByArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.groupBies = mapped
    }

    /**
     * @param value The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("jafpvbifmqbsjypg")
    public suspend fun statistics(`value`: List<HybridMonitorSlsTaskSlsProcessConfigStatisticArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param argument The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("wbojcgiichjyiaxb")
    public suspend fun statistics(argument: List<suspend HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statistics = mapped
    }

    /**
     * @param argument The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("tgucodbcscxsuyqd")
    public suspend fun statistics(vararg argument: suspend HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.statistics = mapped
    }

    /**
     * @param argument The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("kpnuviyfxmqxuqto")
    public suspend fun statistics(argument: suspend HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder().applySuspend
                { argument() }.build(),
        )
        val mapped = of(toBeMapped)
        this.statistics = mapped
    }

    /**
     * @param values The method that is used to aggregate logs imported from Log Service. See `statistics` below.
     */
    @JvmName("xieyhmvvcnlmjuiw")
    public suspend fun statistics(vararg values: HybridMonitorSlsTaskSlsProcessConfigStatisticArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigArgs =
        HybridMonitorSlsTaskSlsProcessConfigArgs(
            expresses = expresses,
            filter = filter,
            groupBies = groupBies,
            statistics = statistics,
        )
}
