@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigExpressArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property express The extended field that specifies the result of basic operations that are performed on aggregation results.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigExpressArgs(
    public val alias: Output<String>? = null,
    public val express: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigExpressArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigExpressArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigExpressArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .express(express?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigExpressArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigExpressArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var express: Output<String>? = null

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("svnwwhoyyntnibuq")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("uskfccmqvvypdmsr")
    public suspend fun express(`value`: Output<String>) {
        this.express = value
    }

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("mtvigpgpmcqjyiej")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("mhukusulhrfjwpxf")
    public suspend fun express(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.express = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigExpressArgs =
        HybridMonitorSlsTaskSlsProcessConfigExpressArgs(
            alias = alias,
            express = express,
        )
}
