@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property filters The conditions that are used to filter logs imported from Log Service. See `filters` below.
 * @property relation The relationship between multiple filter conditions. Valid values: `and`(default value), `or`.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigFilterArgs(
    public val filters: Output<List<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>>? = null,
    public val relation: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterArgs.builder()
            .filters(
                filters?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .relation(relation?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigFilterArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigFilterArgsBuilder internal constructor() {
    private var filters: Output<List<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>>? = null

    private var relation: Output<String>? = null

    /**
     * @param value The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("fjtewmhtopvymrii")
    public suspend fun filters(`value`: Output<List<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>>) {
        this.filters = value
    }

    @JvmName("bmjshaamsskgeuok")
    public suspend fun filters(vararg values: Output<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>) {
        this.filters = Output.all(values.asList())
    }

    /**
     * @param values The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("rhvsmiirjjpgvdxs")
    public suspend fun filters(values: List<Output<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>>) {
        this.filters = Output.all(values)
    }

    /**
     * @param value The relationship between multiple filter conditions. Valid values: `and`(default value), `or`.
     */
    @JvmName("nicokmgrhsiwrbbk")
    public suspend fun relation(`value`: Output<String>) {
        this.relation = value
    }

    /**
     * @param value The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("hovbfrmyfbspvlxu")
    public suspend fun filters(`value`: List<HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("gnkbqgdwsnnbfdjg")
    public suspend fun filters(argument: List<suspend HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("shdweccdypvywwwl")
    public suspend fun filters(vararg argument: suspend HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder().applySuspend { it() }.build()
        }
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param argument The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("fgpqgtffdigdhwxg")
    public suspend fun filters(argument: suspend HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder.() -> Unit) {
        val toBeMapped =
            listOf(
                HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder().applySuspend {
                    argument()
                }.build(),
            )
        val mapped = of(toBeMapped)
        this.filters = mapped
    }

    /**
     * @param values The conditions that are used to filter logs imported from Log Service. See `filters` below.
     */
    @JvmName("tqlrfehdeqdpmlie")
    public suspend fun filters(vararg values: HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.filters = mapped
    }

    /**
     * @param value The relationship between multiple filter conditions. Valid values: `and`(default value), `or`.
     */
    @JvmName("hisroacbnvlgjetd")
    public suspend fun relation(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.relation = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigFilterArgs =
        HybridMonitorSlsTaskSlsProcessConfigFilterArgs(
            filters = filters,
            relation = relation,
        )
}
