@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property operator The method that is used to filter logs imported from Log Service. Valid values: `>`, `>=`, `=`, `<=`, `<`, `!=`, `contain`, `notContain`.
 * @property slsKeyName The name of the key that is used to filter logs imported from Log Service.
 * @property value
 */
public data class HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs(
    public val `operator`: Output<String>? = null,
    public val slsKeyName: Output<String>? = null,
    public val `value`: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs.builder()
            .`operator`(`operator`?.applyValue({ args0 -> args0 }))
            .slsKeyName(slsKeyName?.applyValue({ args0 -> args0 }))
            .`value`(`value`?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgsBuilder internal constructor() {
    private var `operator`: Output<String>? = null

    private var slsKeyName: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value The method that is used to filter logs imported from Log Service. Valid values: `>`, `>=`, `=`, `<=`, `<`, `!=`, `contain`, `notContain`.
     */
    @JvmName("ppxqgamjdxpulkxd")
    public suspend fun `operator`(`value`: Output<String>) {
        this.`operator` = value
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("kytcuwcswqlvwnwg")
    public suspend fun slsKeyName(`value`: Output<String>) {
        this.slsKeyName = value
    }

    /**
     * @param value
     */
    @JvmName("hgsnecgsnonvsvvy")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value The method that is used to filter logs imported from Log Service. Valid values: `>`, `>=`, `=`, `<=`, `<`, `!=`, `contain`, `notContain`.
     */
    @JvmName("vfbvdrigxsiefqqp")
    public suspend fun `operator`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`operator` = mapped
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("mjetyepmnpstmyjy")
    public suspend fun slsKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsKeyName = mapped
    }

    /**
     * @param value
     */
    @JvmName("klqffadukwmjcsso")
    public suspend fun `value`(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs =
        HybridMonitorSlsTaskSlsProcessConfigFilterFilterArgs(
            `operator` = `operator`,
            slsKeyName = slsKeyName,
            `value` = `value`,
        )
}
