@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigGroupByArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property slsKeyName The name of the key that is used to filter logs imported from Log Service.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigGroupByArgs(
    public val alias: Output<String>? = null,
    public val slsKeyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigGroupByArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigGroupByArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigGroupByArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .slsKeyName(slsKeyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigGroupByArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigGroupByArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var slsKeyName: Output<String>? = null

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("kkjltnsrhtupfvur")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("rurelpkckhogoeaj")
    public suspend fun slsKeyName(`value`: Output<String>) {
        this.slsKeyName = value
    }

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("augedjeyamifapcf")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("egvvmckfchgxkuro")
    public suspend fun slsKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsKeyName = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigGroupByArgs =
        HybridMonitorSlsTaskSlsProcessConfigGroupByArgs(
            alias = alias,
            slsKeyName = slsKeyName,
        )
}
