@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigStatisticArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property alias The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
 * @property function The function that is used to aggregate log data within a statistical period. Valid values: `count`, `sum`, `avg`, `max`, `min`, `value`, `countps`, `sumps`, `distinct`, `distribution`, `percentile`.
 * @property parameterOne The value of the function that is used to aggregate logs imported from Log Service.
 * - If you set the `function` parameter to `distribution`, this parameter specifies the lower limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 200.
 * - If you set the `function` parameter to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
 * @property parameterTwo The value of the function that is used to aggregate logs imported from Log Service. **Note:** This parameter is required only if the `function` parameter is set to `distribution`. This parameter specifies the upper limit of the statistical interval.
 * @property slsKeyName The name of the key that is used to filter logs imported from Log Service.
 */
public data class HybridMonitorSlsTaskSlsProcessConfigStatisticArgs(
    public val alias: Output<String>? = null,
    public val function: Output<String>? = null,
    public val parameterOne: Output<String>? = null,
    public val parameterTwo: Output<String>? = null,
    public val slsKeyName: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigStatisticArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigStatisticArgs =
        com.pulumi.alicloud.cms.inputs.HybridMonitorSlsTaskSlsProcessConfigStatisticArgs.builder()
            .alias(alias?.applyValue({ args0 -> args0 }))
            .function(function?.applyValue({ args0 -> args0 }))
            .parameterOne(parameterOne?.applyValue({ args0 -> args0 }))
            .parameterTwo(parameterTwo?.applyValue({ args0 -> args0 }))
            .slsKeyName(slsKeyName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [HybridMonitorSlsTaskSlsProcessConfigStatisticArgs].
 */
@PulumiTagMarker
public class HybridMonitorSlsTaskSlsProcessConfigStatisticArgsBuilder internal constructor() {
    private var alias: Output<String>? = null

    private var function: Output<String>? = null

    private var parameterOne: Output<String>? = null

    private var parameterTwo: Output<String>? = null

    private var slsKeyName: Output<String>? = null

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("wxfhbfqwltmoxrif")
    public suspend fun alias(`value`: Output<String>) {
        this.alias = value
    }

    /**
     * @param value The function that is used to aggregate log data within a statistical period. Valid values: `count`, `sum`, `avg`, `max`, `min`, `value`, `countps`, `sumps`, `distinct`, `distribution`, `percentile`.
     */
    @JvmName("cncodoucbsmlvyfx")
    public suspend fun function(`value`: Output<String>) {
        this.function = value
    }

    /**
     * @param value The value of the function that is used to aggregate logs imported from Log Service.
     * - If you set the `function` parameter to `distribution`, this parameter specifies the lower limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 200.
     * - If you set the `function` parameter to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
     */
    @JvmName("cnlgqsijdhdcbcwc")
    public suspend fun parameterOne(`value`: Output<String>) {
        this.parameterOne = value
    }

    /**
     * @param value The value of the function that is used to aggregate logs imported from Log Service. **Note:** This parameter is required only if the `function` parameter is set to `distribution`. This parameter specifies the upper limit of the statistical interval.
     */
    @JvmName("cnbmhocjrqkfclau")
    public suspend fun parameterTwo(`value`: Output<String>) {
        this.parameterTwo = value
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("rfhfrpyiceweqebr")
    public suspend fun slsKeyName(`value`: Output<String>) {
        this.slsKeyName = value
    }

    /**
     * @param value The alias of the extended field that specifies the result of basic operations that are performed on aggregation results.
     */
    @JvmName("aldjhkriyenxdshj")
    public suspend fun alias(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.alias = mapped
    }

    /**
     * @param value The function that is used to aggregate log data within a statistical period. Valid values: `count`, `sum`, `avg`, `max`, `min`, `value`, `countps`, `sumps`, `distinct`, `distribution`, `percentile`.
     */
    @JvmName("xeyyxygnunvfuqui")
    public suspend fun function(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.function = mapped
    }

    /**
     * @param value The value of the function that is used to aggregate logs imported from Log Service.
     * - If you set the `function` parameter to `distribution`, this parameter specifies the lower limit of the statistical interval. For example, if you want to calculate the number of HTTP requests whose status code is 2XX, set this parameter to 200.
     * - If you set the `function` parameter to `percentile`, this parameter specifies the percentile at which the expected value is. For example, 0.5 specifies P50.
     */
    @JvmName("jmplkfveltnivdok")
    public suspend fun parameterOne(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterOne = mapped
    }

    /**
     * @param value The value of the function that is used to aggregate logs imported from Log Service. **Note:** This parameter is required only if the `function` parameter is set to `distribution`. This parameter specifies the upper limit of the statistical interval.
     */
    @JvmName("uaxfuxqpbjawwiww")
    public suspend fun parameterTwo(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.parameterTwo = mapped
    }

    /**
     * @param value The name of the key that is used to filter logs imported from Log Service.
     */
    @JvmName("xpvnudmutwngrqkn")
    public suspend fun slsKeyName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsKeyName = mapped
    }

    internal fun build(): HybridMonitorSlsTaskSlsProcessConfigStatisticArgs =
        HybridMonitorSlsTaskSlsProcessConfigStatisticArgs(
            alias = alias,
            function = function,
            parameterOne = parameterOne,
            parameterTwo = parameterTwo,
            slsKeyName = slsKeyName,
        )
}
