@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.MetricRuleBlackListMetricArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property metricName The name of the monitoring indicator.
 * @property resource The extended dimension information of the instance. For example, '{"device":"C:"}' indicates that the blacklist policy is applied to all C disks under the ECS instance.
 */
public data class MetricRuleBlackListMetricArgs(
    public val metricName: Output<String>,
    public val resource: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.MetricRuleBlackListMetricArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.MetricRuleBlackListMetricArgs =
        com.pulumi.alicloud.cms.inputs.MetricRuleBlackListMetricArgs.builder()
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .resource(resource?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricRuleBlackListMetricArgs].
 */
@PulumiTagMarker
public class MetricRuleBlackListMetricArgsBuilder internal constructor() {
    private var metricName: Output<String>? = null

    private var resource: Output<String>? = null

    /**
     * @param value The name of the monitoring indicator.
     */
    @JvmName("qjwgyjgsicrelxbq")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The extended dimension information of the instance. For example, '{"device":"C:"}' indicates that the blacklist policy is applied to all C disks under the ECS instance.
     */
    @JvmName("sllmrcgcbnmswbgc")
    public suspend fun resource(`value`: Output<String>) {
        this.resource = value
    }

    /**
     * @param value The name of the monitoring indicator.
     */
    @JvmName("lcbtukqqtnetgsmh")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The extended dimension information of the instance. For example, '{"device":"C:"}' indicates that the blacklist policy is applied to all C disks under the ECS instance.
     */
    @JvmName("fcprudxsrdwwyyvb")
    public suspend fun resource(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.resource = mapped
    }

    internal fun build(): MetricRuleBlackListMetricArgs = MetricRuleBlackListMetricArgs(
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        resource = resource,
    )
}
