@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property category The abbreviation of the Alibaba Cloud service name.
 * > **NOTE:** To obtain the abbreviation of an Alibaba Cloud service name, call the [DescribeProjectMeta](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-describeprojectmeta) operation. The metricCategory tag in the Labels response parameter indicates the abbreviation of the Alibaba Cloud service name.
 * @property escalations The information about the trigger condition based on the alert level. See `escalations` below.
 * @property metricName The name of the metric.
 * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property namespace The namespace of the cloud service.
 * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
 * @property ruleName The name of the alert rule.
 * @property webhook The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
 */
public data class MetricRuleTemplateAlertTemplateArgs(
    public val category: Output<String>,
    public val escalations: Output<MetricRuleTemplateAlertTemplateEscalationsArgs>? = null,
    public val metricName: Output<String>,
    public val namespace: Output<String>,
    public val ruleName: Output<String>,
    public val webhook: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs =
        com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateArgs.builder()
            .category(category.applyValue({ args0 -> args0 }))
            .escalations(escalations?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .metricName(metricName.applyValue({ args0 -> args0 }))
            .namespace(namespace.applyValue({ args0 -> args0 }))
            .ruleName(ruleName.applyValue({ args0 -> args0 }))
            .webhook(webhook?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricRuleTemplateAlertTemplateArgs].
 */
@PulumiTagMarker
public class MetricRuleTemplateAlertTemplateArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var escalations: Output<MetricRuleTemplateAlertTemplateEscalationsArgs>? = null

    private var metricName: Output<String>? = null

    private var namespace: Output<String>? = null

    private var ruleName: Output<String>? = null

    private var webhook: Output<String>? = null

    /**
     * @param value The abbreviation of the Alibaba Cloud service name.
     * > **NOTE:** To obtain the abbreviation of an Alibaba Cloud service name, call the [DescribeProjectMeta](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-describeprojectmeta) operation. The metricCategory tag in the Labels response parameter indicates the abbreviation of the Alibaba Cloud service name.
     */
    @JvmName("gfhjlxsuwiutpegf")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The information about the trigger condition based on the alert level. See `escalations` below.
     */
    @JvmName("ffcligthmlkldkid")
    public suspend fun escalations(`value`: Output<MetricRuleTemplateAlertTemplateEscalationsArgs>) {
        this.escalations = value
    }

    /**
     * @param value The name of the metric.
     * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("mcagbtmtaxwvearb")
    public suspend fun metricName(`value`: Output<String>) {
        this.metricName = value
    }

    /**
     * @param value The namespace of the cloud service.
     * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("fpoxbftdsyndjbyk")
    public suspend fun namespace(`value`: Output<String>) {
        this.namespace = value
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("offkgiywuyhssgkb")
    public suspend fun ruleName(`value`: Output<String>) {
        this.ruleName = value
    }

    /**
     * @param value The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
     */
    @JvmName("vwvpskqykwgluaus")
    public suspend fun webhook(`value`: Output<String>) {
        this.webhook = value
    }

    /**
     * @param value The abbreviation of the Alibaba Cloud service name.
     * > **NOTE:** To obtain the abbreviation of an Alibaba Cloud service name, call the [DescribeProjectMeta](https://www.alibabacloud.com/help/en/cms/developer-reference/api-cms-2019-01-01-describeprojectmeta) operation. The metricCategory tag in the Labels response parameter indicates the abbreviation of the Alibaba Cloud service name.
     */
    @JvmName("hfoebkputftijwmw")
    public suspend fun category(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The information about the trigger condition based on the alert level. See `escalations` below.
     */
    @JvmName("oiibilvjjhookkxm")
    public suspend fun escalations(`value`: MetricRuleTemplateAlertTemplateEscalationsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.escalations = mapped
    }

    /**
     * @param argument The information about the trigger condition based on the alert level. See `escalations` below.
     */
    @JvmName("vpyaqjloqtlvdpfd")
    public suspend fun escalations(argument: suspend MetricRuleTemplateAlertTemplateEscalationsArgsBuilder.() -> Unit) {
        val toBeMapped = MetricRuleTemplateAlertTemplateEscalationsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.escalations = mapped
    }

    /**
     * @param value The name of the metric.
     * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("gswfrqqlrclhdvql")
    public suspend fun metricName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.metricName = mapped
    }

    /**
     * @param value The namespace of the cloud service.
     * > **NOTE:** For more information, see [DescribeMetricMetaList](https://www&#46;alibabacloud&#46;com/help/doc-detail/98846&#46;htm) or [Appendix 1: Metrics](https://www.alibabacloud.com/help/doc-detail/28619.htm).
     */
    @JvmName("ncmgfsccdupnroym")
    public suspend fun namespace(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.namespace = mapped
    }

    /**
     * @param value The name of the alert rule.
     */
    @JvmName("cersiansnsxklaph")
    public suspend fun ruleName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.ruleName = mapped
    }

    /**
     * @param value The callback URL to which a POST request is sent when an alert is triggered based on the alert rule.
     */
    @JvmName("ufwxfmadpidadybl")
    public suspend fun webhook(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.webhook = mapped
    }

    internal fun build(): MetricRuleTemplateAlertTemplateArgs = MetricRuleTemplateAlertTemplateArgs(
        category = category ?: throw PulumiNullFieldException("category"),
        escalations = escalations,
        metricName = metricName ?: throw PulumiNullFieldException("metricName"),
        namespace = namespace ?: throw PulumiNullFieldException("namespace"),
        ruleName = ruleName ?: throw PulumiNullFieldException("ruleName"),
        webhook = webhook,
    )
}
