@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property critical The condition for triggering critical-level alerts. See `critical` below.
 * @property info The condition for triggering info-level alerts. See `info` below.
 * @property warn The condition for triggering warn-level alerts. See `warn` below.
 */
public data class MetricRuleTemplateAlertTemplateEscalationsArgs(
    public val critical: Output<MetricRuleTemplateAlertTemplateEscalationsCriticalArgs>? = null,
    public val info: Output<MetricRuleTemplateAlertTemplateEscalationsInfoArgs>? = null,
    public val warn: Output<MetricRuleTemplateAlertTemplateEscalationsWarnArgs>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs =
        com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsArgs.builder()
            .critical(critical?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .info(info?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .warn(warn?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [MetricRuleTemplateAlertTemplateEscalationsArgs].
 */
@PulumiTagMarker
public class MetricRuleTemplateAlertTemplateEscalationsArgsBuilder internal constructor() {
    private var critical: Output<MetricRuleTemplateAlertTemplateEscalationsCriticalArgs>? = null

    private var info: Output<MetricRuleTemplateAlertTemplateEscalationsInfoArgs>? = null

    private var warn: Output<MetricRuleTemplateAlertTemplateEscalationsWarnArgs>? = null

    /**
     * @param value The condition for triggering critical-level alerts. See `critical` below.
     */
    @JvmName("rocfdaylorfhlydq")
    public suspend fun critical(`value`: Output<MetricRuleTemplateAlertTemplateEscalationsCriticalArgs>) {
        this.critical = value
    }

    /**
     * @param value The condition for triggering info-level alerts. See `info` below.
     */
    @JvmName("louysctsujpwmtey")
    public suspend fun info(`value`: Output<MetricRuleTemplateAlertTemplateEscalationsInfoArgs>) {
        this.info = value
    }

    /**
     * @param value The condition for triggering warn-level alerts. See `warn` below.
     */
    @JvmName("autuwmwbuosgvbmb")
    public suspend fun warn(`value`: Output<MetricRuleTemplateAlertTemplateEscalationsWarnArgs>) {
        this.warn = value
    }

    /**
     * @param value The condition for triggering critical-level alerts. See `critical` below.
     */
    @JvmName("sjhrwxtgreeirtui")
    public suspend fun critical(`value`: MetricRuleTemplateAlertTemplateEscalationsCriticalArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.critical = mapped
    }

    /**
     * @param argument The condition for triggering critical-level alerts. See `critical` below.
     */
    @JvmName("dsxgavqugmustcbm")
    public suspend fun critical(argument: suspend MetricRuleTemplateAlertTemplateEscalationsCriticalArgsBuilder.() -> Unit) {
        val toBeMapped = MetricRuleTemplateAlertTemplateEscalationsCriticalArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.critical = mapped
    }

    /**
     * @param value The condition for triggering info-level alerts. See `info` below.
     */
    @JvmName("orsdvwmikbppwani")
    public suspend fun info(`value`: MetricRuleTemplateAlertTemplateEscalationsInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.info = mapped
    }

    /**
     * @param argument The condition for triggering info-level alerts. See `info` below.
     */
    @JvmName("wuovcpcwkxeopdln")
    public suspend fun info(argument: suspend MetricRuleTemplateAlertTemplateEscalationsInfoArgsBuilder.() -> Unit) {
        val toBeMapped = MetricRuleTemplateAlertTemplateEscalationsInfoArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.info = mapped
    }

    /**
     * @param value The condition for triggering warn-level alerts. See `warn` below.
     */
    @JvmName("axvdjjlmsaebqkou")
    public suspend fun warn(`value`: MetricRuleTemplateAlertTemplateEscalationsWarnArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.warn = mapped
    }

    /**
     * @param argument The condition for triggering warn-level alerts. See `warn` below.
     */
    @JvmName("dawtspdnlxbjljfr")
    public suspend fun warn(argument: suspend MetricRuleTemplateAlertTemplateEscalationsWarnArgsBuilder.() -> Unit) {
        val toBeMapped = MetricRuleTemplateAlertTemplateEscalationsWarnArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.warn = mapped
    }

    internal fun build(): MetricRuleTemplateAlertTemplateEscalationsArgs =
        MetricRuleTemplateAlertTemplateEscalationsArgs(
            critical = critical,
            info = info,
            warn = warn,
        )
}
