@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsInfoArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property comparisonOperator The comparison operator of the threshold for warn-level alerts. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
 * @property statistics The statistical aggregation method for warn-level alerts.
 * @property threshold The threshold for warn-level alerts.
 * @property times The consecutive number of times for which the metric value is measured before a warn-level alert is triggered.
 */
public data class MetricRuleTemplateAlertTemplateEscalationsInfoArgs(
    public val comparisonOperator: Output<String>? = null,
    public val statistics: Output<String>? = null,
    public val threshold: Output<String>? = null,
    public val times: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsInfoArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsInfoArgs =
        com.pulumi.alicloud.cms.inputs.MetricRuleTemplateAlertTemplateEscalationsInfoArgs.builder()
            .comparisonOperator(comparisonOperator?.applyValue({ args0 -> args0 }))
            .statistics(statistics?.applyValue({ args0 -> args0 }))
            .threshold(threshold?.applyValue({ args0 -> args0 }))
            .times(times?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MetricRuleTemplateAlertTemplateEscalationsInfoArgs].
 */
@PulumiTagMarker
public class MetricRuleTemplateAlertTemplateEscalationsInfoArgsBuilder internal constructor() {
    private var comparisonOperator: Output<String>? = null

    private var statistics: Output<String>? = null

    private var threshold: Output<String>? = null

    private var times: Output<String>? = null

    /**
     * @param value The comparison operator of the threshold for warn-level alerts. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
     */
    @JvmName("hdmjemtsvkeyukuq")
    public suspend fun comparisonOperator(`value`: Output<String>) {
        this.comparisonOperator = value
    }

    /**
     * @param value The statistical aggregation method for warn-level alerts.
     */
    @JvmName("dvshlhgbnvbfmrwk")
    public suspend fun statistics(`value`: Output<String>) {
        this.statistics = value
    }

    /**
     * @param value The threshold for warn-level alerts.
     */
    @JvmName("ytyqcoabsapcudio")
    public suspend fun threshold(`value`: Output<String>) {
        this.threshold = value
    }

    /**
     * @param value The consecutive number of times for which the metric value is measured before a warn-level alert is triggered.
     */
    @JvmName("glrfqlfjxvtlwtve")
    public suspend fun times(`value`: Output<String>) {
        this.times = value
    }

    /**
     * @param value The comparison operator of the threshold for warn-level alerts. Valid values: `GreaterThanOrEqualToThreshold`, `GreaterThanThreshold`, `LessThanOrEqualToThreshold`, `LessThanThreshold`, `NotEqualToThreshold`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`.
     */
    @JvmName("vbanpluybvsevbxl")
    public suspend fun comparisonOperator(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.comparisonOperator = mapped
    }

    /**
     * @param value The statistical aggregation method for warn-level alerts.
     */
    @JvmName("adafqcaoucniuqbd")
    public suspend fun statistics(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.statistics = mapped
    }

    /**
     * @param value The threshold for warn-level alerts.
     */
    @JvmName("vrpqxbkpqvidqrwg")
    public suspend fun threshold(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.threshold = mapped
    }

    /**
     * @param value The consecutive number of times for which the metric value is measured before a warn-level alert is triggered.
     */
    @JvmName("pumuqjluhkeuqikh")
    public suspend fun times(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.times = mapped
    }

    internal fun build(): MetricRuleTemplateAlertTemplateEscalationsInfoArgs =
        MetricRuleTemplateAlertTemplateEscalationsInfoArgs(
            comparisonOperator = comparisonOperator,
            statistics = statistics,
            threshold = threshold,
            times = times,
        )
}
