@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.MonitorGroupInstancesInstanceArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property category The category of instance.
 * @property instanceId The id of instance.
 * @property instanceName The name of instance.
 * @property regionId The region id of instance.
 */
public data class MonitorGroupInstancesInstanceArgs(
    public val category: Output<String>,
    public val instanceId: Output<String>,
    public val instanceName: Output<String>,
    public val regionId: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.MonitorGroupInstancesInstanceArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.MonitorGroupInstancesInstanceArgs =
        com.pulumi.alicloud.cms.inputs.MonitorGroupInstancesInstanceArgs.builder()
            .category(category.applyValue({ args0 -> args0 }))
            .instanceId(instanceId.applyValue({ args0 -> args0 }))
            .instanceName(instanceName.applyValue({ args0 -> args0 }))
            .regionId(regionId.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [MonitorGroupInstancesInstanceArgs].
 */
@PulumiTagMarker
public class MonitorGroupInstancesInstanceArgsBuilder internal constructor() {
    private var category: Output<String>? = null

    private var instanceId: Output<String>? = null

    private var instanceName: Output<String>? = null

    private var regionId: Output<String>? = null

    /**
     * @param value The category of instance.
     */
    @JvmName("npqrjqeoycrnkbsy")
    public suspend fun category(`value`: Output<String>) {
        this.category = value
    }

    /**
     * @param value The id of instance.
     */
    @JvmName("ghipeuebkaebcgsq")
    public suspend fun instanceId(`value`: Output<String>) {
        this.instanceId = value
    }

    /**
     * @param value The name of instance.
     */
    @JvmName("pdkqjoxqtsulokwj")
    public suspend fun instanceName(`value`: Output<String>) {
        this.instanceName = value
    }

    /**
     * @param value The region id of instance.
     */
    @JvmName("omroptjoptncortr")
    public suspend fun regionId(`value`: Output<String>) {
        this.regionId = value
    }

    /**
     * @param value The category of instance.
     */
    @JvmName("hxfsvdpeaoksljgu")
    public suspend fun category(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.category = mapped
    }

    /**
     * @param value The id of instance.
     */
    @JvmName("xvjccdvsngbdjuhr")
    public suspend fun instanceId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceId = mapped
    }

    /**
     * @param value The name of instance.
     */
    @JvmName("pocgekbdhpgbefnq")
    public suspend fun instanceName(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.instanceName = mapped
    }

    /**
     * @param value The region id of instance.
     */
    @JvmName("oosmsagqoxsqwswu")
    public suspend fun regionId(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.regionId = mapped
    }

    internal fun build(): MonitorGroupInstancesInstanceArgs = MonitorGroupInstancesInstanceArgs(
        category = category ?: throw PulumiNullFieldException("category"),
        instanceId = instanceId ?: throw PulumiNullFieldException("instanceId"),
        instanceName = instanceName ?: throw PulumiNullFieldException("instanceName"),
        regionId = regionId ?: throw PulumiNullFieldException("regionId"),
    )
}
