@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property city The ID of the city.
 * @property isp The ID of the carrier.
 */
public data class SiteMonitorIspCityArgs(
    public val city: Output<String>,
    public val isp: Output<String>,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs =
        com.pulumi.alicloud.cms.inputs.SiteMonitorIspCityArgs.builder()
            .city(city.applyValue({ args0 -> args0 }))
            .isp(isp.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SiteMonitorIspCityArgs].
 */
@PulumiTagMarker
public class SiteMonitorIspCityArgsBuilder internal constructor() {
    private var city: Output<String>? = null

    private var isp: Output<String>? = null

    /**
     * @param value The ID of the city.
     */
    @JvmName("qsxbdcxobgvrlwfv")
    public suspend fun city(`value`: Output<String>) {
        this.city = value
    }

    /**
     * @param value The ID of the carrier.
     */
    @JvmName("blurnqrkfkpfrwuo")
    public suspend fun isp(`value`: Output<String>) {
        this.isp = value
    }

    /**
     * @param value The ID of the city.
     */
    @JvmName("odidfstgmeclpfkx")
    public suspend fun city(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.city = mapped
    }

    /**
     * @param value The ID of the carrier.
     */
    @JvmName("ythryqrvfskqhvcg")
    public suspend fun isp(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.isp = mapped
    }

    internal fun build(): SiteMonitorIspCityArgs = SiteMonitorIspCityArgs(
        city = city ?: throw PulumiNullFieldException("city"),
        isp = isp ?: throw PulumiNullFieldException("isp"),
    )
}
