@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.inputs

import com.pulumi.alicloud.cms.inputs.SlsGroupSlsGroupConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property slsLogstore The name of the Log Store.
 * @property slsProject The name of the Project.
 * @property slsRegion The Sls Region.
 * @property slsUserId The ID of the Sls User.
 */
public data class SlsGroupSlsGroupConfigArgs(
    public val slsLogstore: Output<String>,
    public val slsProject: Output<String>,
    public val slsRegion: Output<String>,
    public val slsUserId: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.alicloud.cms.inputs.SlsGroupSlsGroupConfigArgs> {
    override fun toJava(): com.pulumi.alicloud.cms.inputs.SlsGroupSlsGroupConfigArgs =
        com.pulumi.alicloud.cms.inputs.SlsGroupSlsGroupConfigArgs.builder()
            .slsLogstore(slsLogstore.applyValue({ args0 -> args0 }))
            .slsProject(slsProject.applyValue({ args0 -> args0 }))
            .slsRegion(slsRegion.applyValue({ args0 -> args0 }))
            .slsUserId(slsUserId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [SlsGroupSlsGroupConfigArgs].
 */
@PulumiTagMarker
public class SlsGroupSlsGroupConfigArgsBuilder internal constructor() {
    private var slsLogstore: Output<String>? = null

    private var slsProject: Output<String>? = null

    private var slsRegion: Output<String>? = null

    private var slsUserId: Output<String>? = null

    /**
     * @param value The name of the Log Store.
     */
    @JvmName("gbkkugmbycixdept")
    public suspend fun slsLogstore(`value`: Output<String>) {
        this.slsLogstore = value
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("uwdlvmwbqyyugvkn")
    public suspend fun slsProject(`value`: Output<String>) {
        this.slsProject = value
    }

    /**
     * @param value The Sls Region.
     */
    @JvmName("wbkbbsoraheaknqo")
    public suspend fun slsRegion(`value`: Output<String>) {
        this.slsRegion = value
    }

    /**
     * @param value The ID of the Sls User.
     */
    @JvmName("yqamgyetpjsswikl")
    public suspend fun slsUserId(`value`: Output<String>) {
        this.slsUserId = value
    }

    /**
     * @param value The name of the Log Store.
     */
    @JvmName("urupuvotlbglmlhw")
    public suspend fun slsLogstore(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slsLogstore = mapped
    }

    /**
     * @param value The name of the Project.
     */
    @JvmName("dvudlxxewuecchgh")
    public suspend fun slsProject(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slsProject = mapped
    }

    /**
     * @param value The Sls Region.
     */
    @JvmName("jiojkkenfownmmmu")
    public suspend fun slsRegion(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.slsRegion = mapped
    }

    /**
     * @param value The ID of the Sls User.
     */
    @JvmName("iyuykyeslpyglsji")
    public suspend fun slsUserId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.slsUserId = mapped
    }

    internal fun build(): SlsGroupSlsGroupConfigArgs = SlsGroupSlsGroupConfigArgs(
        slsLogstore = slsLogstore ?: throw PulumiNullFieldException("slsLogstore"),
        slsProject = slsProject ?: throw PulumiNullFieldException("slsProject"),
        slsRegion = slsRegion ?: throw PulumiNullFieldException("slsRegion"),
        slsUserId = slsUserId,
    )
}
