@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property expressionListJoin The relationship between the trigger conditions for multiple metrics. Valid values: `&&`, `||`.
 * @property expressionLists The trigger conditions that are created in standard mode. See `expression_list` below.
 * @property expressionRaw The trigger conditions that are created by using expressions.
 * @property level The level of the alert. Valid values: `CRITICAL`, `WARN`, `INFO`.
 * @property times The number of consecutive triggers.
 */
public data class AlarmCompositeExpression(
    public val expressionListJoin: String? = null,
    public val expressionLists: List<AlarmCompositeExpressionExpressionList>? = null,
    public val expressionRaw: String? = null,
    public val level: String? = null,
    public val times: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.AlarmCompositeExpression): AlarmCompositeExpression = AlarmCompositeExpression(
            expressionListJoin = javaType.expressionListJoin().map({ args0 -> args0 }).orElse(null),
            expressionLists = javaType.expressionLists().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.AlarmCompositeExpressionExpressionList.Companion.toKotlin(args0)
                })
            }),
            expressionRaw = javaType.expressionRaw().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            times = javaType.times().map({ args0 -> args0 }).orElse(null),
        )
    }
}
