@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator
 * @property metricName The metric that is used to monitor the cloud service.
 * @property period The statistical period of the metric. Unit: seconds. Default value: `300`.
 * @property statistics Field `statistics` has been removed from provider version 1.216.0. New field `escalations_critical.statistics` instead.
 * @property threshold Field `threshold` has been removed from provider version 1.216.0. New field `escalations_critical.threshold` instead.
 */
public data class AlarmCompositeExpressionExpressionList(
    public val comparisonOperator: String? = null,
    public val metricName: String? = null,
    public val period: String? = null,
    public val statistics: String? = null,
    public val threshold: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.AlarmCompositeExpressionExpressionList): AlarmCompositeExpressionExpressionList = AlarmCompositeExpressionExpressionList(
            comparisonOperator = javaType.comparisonOperator().map({ args0 -> args0 }).orElse(null),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            period = javaType.period().map({ args0 -> args0 }).orElse(null),
            statistics = javaType.statistics().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
        )
    }
}
