@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property comparisonOperator Info level alarm comparison operator. Default value: `>`. Valid values: `>`, `>=`, `<`, `<=`, `!=`, `GreaterThanYesterday`, `LessThanYesterday`, `GreaterThanLastWeek`, `LessThanLastWeek`, `GreaterThanLastPeriod`, `LessThanLastPeriod`. **NOTE:** From version 1.225.0, `comparison_operator` cannot be set to `==`.
 * @property statistics Info level alarm statistics method. It must be consistent with that defined for metrics. For more information, see [How to use it](https://cms.console.aliyun.com/metric-meta/acs_ecs_dashboard/ecs).
 * @property threshold Info level alarm threshold value, which must be a numeric value currently.
 * @property times Info level alarm retry times. Default value: `3`.
 */
public data class AlarmEscalationsInfo(
    public val comparisonOperator: String? = null,
    public val statistics: String? = null,
    public val threshold: String? = null,
    public val times: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.AlarmEscalationsInfo): AlarmEscalationsInfo = AlarmEscalationsInfo(
            comparisonOperator = javaType.comparisonOperator().map({ args0 -> args0 }).orElse(null),
            statistics = javaType.statistics().map({ args0 -> args0 }).orElse(null),
            threshold = javaType.threshold().map({ args0 -> args0 }).orElse(null),
            times = javaType.times().map({ args0 -> args0 }).orElse(null),
        )
    }
}
