@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property annotations The annotations of the Prometheus alert rule. When a Prometheus alert is triggered, the system renders the annotated keys and values to help you understand the metrics and alert rule.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 * @property promQl The PromQL query statement. **Note:** The data obtained by using the PromQL query statement is the monitoring data. You must include the alert threshold in this statement.
 * @property times The number of consecutive triggers. If the number of times that the metric values meet the trigger conditions reaches the value of this parameter, CloudMonitor sends alert notifications.
 */
public data class AlarmPrometheus(
    public val annotations: Map<String, String>? = null,
    public val level: String? = null,
    public val promQl: String? = null,
    public val times: Int? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.AlarmPrometheus): AlarmPrometheus = AlarmPrometheus(
            annotations = javaType.annotations().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
            promQl = javaType.promQl().map({ args0 -> args0 }).orElse(null),
            times = javaType.times().map({ args0 -> args0 }).orElse(null),
        )
    }
}
