@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn ARN uniquely identifies the resource that the alert targets.
 * > **NOTE:** The targets attribute is used to specify where notifications or actions should be directed when an alarm condition is met. This attribute corresponds to what is referred to as the "Push Channel" in the Alibaba Cloud console.
 * > **NOTE:** Currently, the Alibaba Cloud Resource Name (ARN) of the resource. To use, please [submit an application](https://www.alibabacloud.com/help/en/cloudmonitor/latest/describemetricruletargets).
 * @property jsonParams Specifies additional parameters for the alert callback in JSON format. This can include configuration settings specific to the alert action.
 * @property level The level of the alert. Valid values: `Critical`, `Warn`, `Info`.
 * @property targetId The ID of the resource for which alerts are triggered. This is typically used to specify individual resources that should respond to the alert.
 */
public data class AlarmTarget(
    public val arn: String? = null,
    public val jsonParams: String? = null,
    public val level: String? = null,
    public val targetId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.AlarmTarget): AlarmTarget =
            AlarmTarget(
                arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
                jsonParams = javaType.jsonParams().map({ args0 -> args0 }).orElse(null),
                level = javaType.level().map({ args0 -> args0 }).orElse(null),
                targetId = javaType.targetId().map({ args0 -> args0 }).orElse(null),
            )
    }
}
