@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property tagValue The tag values of the cloud resources.
 * @property tagValueMatchFunction The method that is used to match the tag values of the cloud resources. Valid values: `all`, `startWith`, `endWith`, `contains`, `notContains`, `equals`.
 */
public data class DynamicTagGroupMatchExpress(
    public val tagValue: String,
    public val tagValueMatchFunction: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.DynamicTagGroupMatchExpress): DynamicTagGroupMatchExpress = DynamicTagGroupMatchExpress(
            tagValue = javaType.tagValue(),
            tagValueMatchFunction = javaType.tagValueMatchFunction(),
        )
    }
}
