@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property contactGroupName The name of the alert contact group.
 * @property contactParametersId The ID of the recipient that receives alert notifications.
 * @property level The alert level and the corresponding notification methods.
 */
public data class EventRuleContactParameter(
    public val contactGroupName: String? = null,
    public val contactParametersId: String? = null,
    public val level: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleContactParameter): EventRuleContactParameter = EventRuleContactParameter(
            contactGroupName = javaType.contactGroupName().map({ args0 -> args0 }).orElse(null),
            contactParametersId = javaType.contactParametersId().map({ args0 -> args0 }).orElse(null),
            level = javaType.level().map({ args0 -> args0 }).orElse(null),
        )
    }
}
