@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eventTypeLists The type of the event-triggered alert rule. Valid values:
 * - `StatusNotification`: fault notifications.
 * - `Exception`: exceptions.
 * - `Maintenance`: O&M.
 * - `*`: all types.
 * @property levelLists The level of the event-triggered alert rule. Valid values:
 * - `CRITICAL`: critical.
 * - `WARN`: warning.
 * - `INFO`: information.
 * - `*`: all types.
 * @property nameLists The name of the event-triggered alert rule.
 * @property product The type of the cloud service.
 * @property sqlFilter The SQL condition that is used to filter events. If the content of an event meets the specified SQL condition, an alert is automatically triggered.
 */
public data class EventRuleEventPattern(
    public val eventTypeLists: List<String>? = null,
    public val levelLists: List<String>? = null,
    public val nameLists: List<String>? = null,
    public val product: String,
    public val sqlFilter: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleEventPattern): EventRuleEventPattern = EventRuleEventPattern(
            eventTypeLists = javaType.eventTypeLists().map({ args0 -> args0 }),
            levelLists = javaType.levelLists().map({ args0 -> args0 }),
            nameLists = javaType.nameLists().map({ args0 -> args0 }),
            product = javaType.product(),
            sqlFilter = javaType.sqlFilter().map({ args0 -> args0 }).orElse(null),
        )
    }
}
