@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property fcParametersId The ID of the recipient that receives alert notifications.
 * @property functionName The name of the function.
 * @property region The region where Function Compute is deployed.
 * @property serviceName The name of the Function Compute service.
 */
public data class EventRuleFcParameter(
    public val arn: String? = null,
    public val fcParametersId: String? = null,
    public val functionName: String? = null,
    public val region: String? = null,
    public val serviceName: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleFcParameter): EventRuleFcParameter = EventRuleFcParameter(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            fcParametersId = javaType.fcParametersId().map({ args0 -> args0 }).orElse(null),
            functionName = javaType.functionName().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            serviceName = javaType.serviceName().map({ args0 -> args0 }).orElse(null),
        )
    }
}
