@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property mnsParametersId The ID of the recipient that receives alert notifications.
 * @property queue The name of the MNS queue.
 * @property region The region where Message Service (MNS) is deployed.
 * @property topic The MNS topic.
 */
public data class EventRuleMnsParameter(
    public val arn: String? = null,
    public val mnsParametersId: String? = null,
    public val queue: String? = null,
    public val region: String? = null,
    public val topic: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleMnsParameter): EventRuleMnsParameter = EventRuleMnsParameter(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            mnsParametersId = javaType.mnsParametersId().map({ args0 -> args0 }).orElse(null),
            queue = javaType.queue().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            topic = javaType.topic().map({ args0 -> args0 }).orElse(null),
        )
    }
}
