@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property action The API name.
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property openApiParametersId The ID of the recipient that receives alert notifications sent by an API callback.
 * @property product The ID of the cloud service to which the API operation belongs.
 * @property region The region where the resource resides.
 * @property role The name of the role.
 * @property version The version of the API.
 */
public data class EventRuleOpenApiParameter(
    public val action: String? = null,
    public val arn: String? = null,
    public val openApiParametersId: String? = null,
    public val product: String? = null,
    public val region: String? = null,
    public val role: String? = null,
    public val version: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleOpenApiParameter): EventRuleOpenApiParameter = EventRuleOpenApiParameter(
            action = javaType.action().map({ args0 -> args0 }).orElse(null),
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            openApiParametersId = javaType.openApiParametersId().map({ args0 -> args0 }).orElse(null),
            product = javaType.product().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            role = javaType.role().map({ args0 -> args0 }).orElse(null),
            version = javaType.version().map({ args0 -> args0 }).orElse(null),
        )
    }
}
