@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property arn (Available since v1.211.1) The ARN of the API operation.
 * @property logStore The name of the Simple Log Service Logstore.
 * @property project The name of the Simple Log Service project.
 * @property region The region where Simple Log Service is deployed.
 * @property slsParametersId The ID of the recipient that receives alert notifications.
 */
public data class EventRuleSlsParameter(
    public val arn: String? = null,
    public val logStore: String? = null,
    public val project: String? = null,
    public val region: String? = null,
    public val slsParametersId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleSlsParameter): EventRuleSlsParameter = EventRuleSlsParameter(
            arn = javaType.arn().map({ args0 -> args0 }).orElse(null),
            logStore = javaType.logStore().map({ args0 -> args0 }).orElse(null),
            project = javaType.project().map({ args0 -> args0 }).orElse(null),
            region = javaType.region().map({ args0 -> args0 }).orElse(null),
            slsParametersId = javaType.slsParametersId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
