@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property method The HTTP request method.
 * @property protocol The name of the protocol.
 * @property url The callback URL.
 * @property webhookParametersId The ID of the recipient that receives alert notifications.
 */
public data class EventRuleWebhookParameter(
    public val method: String? = null,
    public val protocol: String? = null,
    public val url: String? = null,
    public val webhookParametersId: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.EventRuleWebhookParameter): EventRuleWebhookParameter = EventRuleWebhookParameter(
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol().map({ args0 -> args0 }).orElse(null),
            url = javaType.url().map({ args0 -> args0 }).orElse(null),
            webhookParametersId = javaType.webhookParametersId().map({ args0 -> args0 }).orElse(null),
        )
    }
}
