@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarmContactGroupName The name of Alarm Contact Group.
 * @property contacts The alarm contacts in the alarm group.
 * @property describe The description of the Alarm Group.
 * @property enableSubscribed Indicates whether the alarm group subscribes to weekly reports.
 * @property id The ID of the CMS.
 */
public data class GetAlarmContactGroupsGroup(
    public val alarmContactGroupName: String,
    public val contacts: List<String>,
    public val describe: String,
    public val enableSubscribed: Boolean,
    public val id: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetAlarmContactGroupsGroup): GetAlarmContactGroupsGroup = GetAlarmContactGroupsGroup(
            alarmContactGroupName = javaType.alarmContactGroupName(),
            contacts = javaType.contacts().map({ args0 -> args0 }),
            describe = javaType.describe(),
            enableSubscribed = javaType.enableSubscribed(),
            id = javaType.id(),
        )
    }
}
