@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property alarmContactName The name of the alarm contact.
 * @property channelsAliim The TradeManager ID of the alarm contact.
 * @property channelsDingWebHook The webhook URL of the DingTalk chatbot.
 * @property channelsMail The email address of the alarm contact.
 * @property channelsSms The phone number of the alarm contact.
 * @property channelsStateAliim Indicates whether the TradeManager ID is valid.
 * @property channelsStateDingWebHook Indicates whether the DingTalk chatbot is normal.
 * @property channelsStateMail The status of the email address.
 * @property channelsStatusSms The status of the phone number.
 * * `Lang` - The language type of the alarm.
 * @property contactGroups The alert groups to which the alarm contact is added.
 * @property describe The description of the alarm contact.
 * @property id The ID of the alarm contact.
 * @property lang
 */
public data class GetAlarmContactsContact(
    public val alarmContactName: String,
    public val channelsAliim: String,
    public val channelsDingWebHook: String,
    public val channelsMail: String,
    public val channelsSms: String,
    public val channelsStateAliim: String,
    public val channelsStateDingWebHook: String,
    public val channelsStateMail: String,
    public val channelsStatusSms: String,
    public val contactGroups: List<String>,
    public val describe: String,
    public val id: String,
    public val lang: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetAlarmContactsContact): GetAlarmContactsContact = GetAlarmContactsContact(
            alarmContactName = javaType.alarmContactName(),
            channelsAliim = javaType.channelsAliim(),
            channelsDingWebHook = javaType.channelsDingWebHook(),
            channelsMail = javaType.channelsMail(),
            channelsSms = javaType.channelsSms(),
            channelsStateAliim = javaType.channelsStateAliim(),
            channelsStateDingWebHook = javaType.channelsStateDingWebHook(),
            channelsStateMail = javaType.channelsStateMail(),
            channelsStatusSms = javaType.channelsStatusSms(),
            contactGroups = javaType.contactGroups().map({ args0 -> args0 }),
            describe = javaType.describe(),
            id = javaType.id(),
            lang = javaType.lang(),
        )
    }
}
