@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getAlarmContacts.
 * @property chanelType
 * @property chanelValue
 * @property contacts A list of alarm contacts. Each element contains the following attributes:
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids A list of alarm contact IDs.
 * @property nameRegex
 * @property names A list of alarm contact names.
 * @property outputFile
 */
public data class GetAlarmContactsResult(
    public val chanelType: String? = null,
    public val chanelValue: String? = null,
    public val contacts: List<GetAlarmContactsContact>,
    public val id: String,
    public val ids: List<String>,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val outputFile: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetAlarmContactsResult): GetAlarmContactsResult = GetAlarmContactsResult(
            chanelType = javaType.chanelType().map({ args0 -> args0 }).orElse(null),
            chanelValue = javaType.chanelValue().map({ args0 -> args0 }).orElse(null),
            contacts = javaType.contacts().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetAlarmContactsContact.Companion.toKotlin(args0)
                })
            }),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
        )
    }
}
