@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property dynamicTagRuleId The ID of the tag rule.
 * @property id The ID of the Dynamic Tag Group.
 * @property matchExpressFilterRelation The relationship between conditional expressions. Valid values: `and`, `or`.
 * @property matchExpresses The label generates a matching expression that applies the grouping. See the following `Block match_express`.
 * @property status The status of the resource. Valid values: `RUNNING`, `FINISH`.
 * @property tagKey The tag key of the tag.
 */
public data class GetDynamicTagGroupsGroup(
    public val dynamicTagRuleId: String,
    public val id: String,
    public val matchExpressFilterRelation: String,
    public val matchExpresses: List<GetDynamicTagGroupsGroupMatchExpress>,
    public val status: String,
    public val tagKey: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetDynamicTagGroupsGroup): GetDynamicTagGroupsGroup = GetDynamicTagGroupsGroup(
            dynamicTagRuleId = javaType.dynamicTagRuleId(),
            id = javaType.id(),
            matchExpressFilterRelation = javaType.matchExpressFilterRelation(),
            matchExpresses = javaType.matchExpresses().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetDynamicTagGroupsGroupMatchExpress.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status(),
            tagKey = javaType.tagKey(),
        )
    }
}
