@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property description The description of the rule.
 * @property eventPatterns Event mode, used to describe the trigger conditions for this event.
 * @property eventRuleName The name of the event rule.
 * @property eventType The type of event.
 * @property groupId The ID of the application Group.
 * @property id The ID of the Event Rule. Its value is same as Event Rule Name.
 * @property silenceTime The mute period during which new alerts are not sent even if the trigger conditions are met.
 * @property status The status of the resource.
 */
public data class GetEventRulesRule(
    public val description: String,
    public val eventPatterns: List<GetEventRulesRuleEventPattern>,
    public val eventRuleName: String,
    public val eventType: String,
    public val groupId: String,
    public val id: String,
    public val silenceTime: Int,
    public val status: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetEventRulesRule): GetEventRulesRule = GetEventRulesRule(
            description = javaType.description(),
            eventPatterns = javaType.eventPatterns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetEventRulesRuleEventPattern.Companion.toKotlin(args0)
                })
            }),
            eventRuleName = javaType.eventRuleName(),
            eventType = javaType.eventType(),
            groupId = javaType.groupId(),
            id = javaType.id(),
            silenceTime = javaType.silenceTime(),
            status = javaType.status(),
        )
    }
}
