@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property eventTypeLists The list of event types.
 * @property keywordFilters The filter keyword.
 * @property levelLists The list of event levels.
 * @property nameLists The list of event names.
 * @property product The type of the cloud service.
 * @property sqlFilter The SQL condition that is used to filter events.
 */
public data class GetEventRulesRuleEventPattern(
    public val eventTypeLists: List<String>,
    public val keywordFilters: List<GetEventRulesRuleEventPatternKeywordFilter>,
    public val levelLists: List<String>,
    public val nameLists: List<String>,
    public val product: String,
    public val sqlFilter: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetEventRulesRuleEventPattern): GetEventRulesRuleEventPattern = GetEventRulesRuleEventPattern(
            eventTypeLists = javaType.eventTypeLists().map({ args0 -> args0 }),
            keywordFilters = javaType.keywordFilters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetEventRulesRuleEventPatternKeywordFilter.Companion.toKotlin(args0)
                })
            }),
            levelLists = javaType.levelLists().map({ args0 -> args0 }),
            nameLists = javaType.nameLists().map({ args0 -> args0 }),
            product = javaType.product(),
            sqlFilter = javaType.sqlFilter(),
        )
    }
}
