@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 * A collection of values returned by getGroupMetricRules.
 * @property dimensions
 * @property enableState
 * @property groupId
 * @property groupMetricRuleName
 * @property id The provider-assigned unique ID for this managed resource.
 * @property ids
 * @property metricName
 * @property nameRegex
 * @property names
 * @property namespace
 * @property outputFile
 * @property rules
 * @property status
 */
public data class GetGroupMetricRulesResult(
    public val dimensions: String? = null,
    public val enableState: Boolean? = null,
    public val groupId: String? = null,
    public val groupMetricRuleName: String? = null,
    public val id: String,
    public val ids: List<String>,
    public val metricName: String? = null,
    public val nameRegex: String? = null,
    public val names: List<String>,
    public val namespace: String? = null,
    public val outputFile: String? = null,
    public val rules: List<GetGroupMetricRulesRule>,
    public val status: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetGroupMetricRulesResult): GetGroupMetricRulesResult = GetGroupMetricRulesResult(
            dimensions = javaType.dimensions().map({ args0 -> args0 }).orElse(null),
            enableState = javaType.enableState().map({ args0 -> args0 }).orElse(null),
            groupId = javaType.groupId().map({ args0 -> args0 }).orElse(null),
            groupMetricRuleName = javaType.groupMetricRuleName().map({ args0 -> args0 }).orElse(null),
            id = javaType.id(),
            ids = javaType.ids().map({ args0 -> args0 }),
            metricName = javaType.metricName().map({ args0 -> args0 }).orElse(null),
            nameRegex = javaType.nameRegex().map({ args0 -> args0 }).orElse(null),
            names = javaType.names().map({ args0 -> args0 }),
            namespace = javaType.namespace().map({ args0 -> args0 }).orElse(null),
            outputFile = javaType.outputFile().map({ args0 -> args0 }).orElse(null),
            rules = javaType.rules().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesRule.Companion.toKotlin(args0)
                })
            }),
            status = javaType.status().map({ args0 -> args0 }).orElse(null),
        )
    }
}
