@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Boolean
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property contactGroups Alarm contact group.
 * @property dimensions The dimensions that specify the resources to be associated with the alert rule.
 * @property effectiveInterval The time period during which the alert rule is effective.
 * @property emailSubject The subject of the alert notification email.
 * @property enableState Indicates whether the alert rule is enabled.
 * @property escalations Alarm level.
 * @property groupId The ID of the application group.
 * @property groupMetricRuleName The name of the alert rule.
 * @property id The ID of the Group Metric Rule.
 * @property metricName The name of the metric.
 * @property namespace The namespace of the service.
 * @property noEffectiveInterval The time period during which the alert rule is ineffective.
 * @property period The aggregation period of the monitoring data. Unit: seconds. The value is an integral multiple of 60. Default value: `300`.
 * @property resources The resources that are associated with the alert rule.
 * @property ruleId The ID of the alert rule.
 * @property silenceTime The mute period during which new alerts are not reported even if the alert trigger conditions are met. Unit: seconds. Default value: `86400`, which is equivalent to one day.
 * @property sourceType The type of the alert rule. The value is fixed to METRIC, indicating an alert rule for time series metrics.
 * @property status The status of Group Metric Rule..
 * @property webhook The callback URL.
 */
public data class GetGroupMetricRulesRule(
    public val contactGroups: String,
    public val dimensions: String,
    public val effectiveInterval: String,
    public val emailSubject: String,
    public val enableState: Boolean,
    public val escalations: List<GetGroupMetricRulesRuleEscalation>,
    public val groupId: String,
    public val groupMetricRuleName: String,
    public val id: String,
    public val metricName: String,
    public val namespace: String,
    public val noEffectiveInterval: String,
    public val period: Int,
    public val resources: String,
    public val ruleId: String,
    public val silenceTime: Int,
    public val sourceType: String,
    public val status: String,
    public val webhook: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetGroupMetricRulesRule): GetGroupMetricRulesRule = GetGroupMetricRulesRule(
            contactGroups = javaType.contactGroups(),
            dimensions = javaType.dimensions(),
            effectiveInterval = javaType.effectiveInterval(),
            emailSubject = javaType.emailSubject(),
            enableState = javaType.enableState(),
            escalations = javaType.escalations().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesRuleEscalation.Companion.toKotlin(args0)
                })
            }),
            groupId = javaType.groupId(),
            groupMetricRuleName = javaType.groupMetricRuleName(),
            id = javaType.id(),
            metricName = javaType.metricName(),
            namespace = javaType.namespace(),
            noEffectiveInterval = javaType.noEffectiveInterval(),
            period = javaType.period(),
            resources = javaType.resources(),
            ruleId = javaType.ruleId(),
            silenceTime = javaType.silenceTime(),
            sourceType = javaType.sourceType(),
            status = javaType.status(),
            webhook = javaType.webhook(),
        )
    }
}
