@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.alicloud.cms.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property criticals The critical level.
 * @property infos The info level.
 * @property warns The warn level.
 */
public data class GetGroupMetricRulesRuleEscalation(
    public val criticals: List<GetGroupMetricRulesRuleEscalationCritical>,
    public val infos: List<GetGroupMetricRulesRuleEscalationInfo>,
    public val warns: List<GetGroupMetricRulesRuleEscalationWarn>,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.alicloud.cms.outputs.GetGroupMetricRulesRuleEscalation): GetGroupMetricRulesRuleEscalation = GetGroupMetricRulesRuleEscalation(
            criticals = javaType.criticals().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesRuleEscalationCritical.Companion.toKotlin(args0)
                })
            }),
            infos = javaType.infos().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesRuleEscalationInfo.Companion.toKotlin(args0)
                })
            }),
            warns = javaType.warns().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.alicloud.cms.kotlin.outputs.GetGroupMetricRulesRuleEscalationWarn.Companion.toKotlin(args0)
                })
            }),
        )
    }
}
